#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
#
# Support module generated by PAGE version 7.6
#  in conjunction with Tcl version 8.6
#    Jan 28, 2024 09:26:48 AM CET  platform: Windows NT

#import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
import os.path

import pkt_gui_rcs

from datetime import datetime
#import binascii

from utility import Chatterbox

terminale = None
root = None

PST = ''
textB1 = ''
textB2 = ''
mexB1 = ''
mexB2 = ''

#****************************************
def initialize():
    global PST
    global textB1
    global textB2
    global mexB1
    global mexB2
    global serverName
    global serverPort

    f = open("Terminale.ini", "r")
    serverName = (f.readline()).strip("\n")
    serverPort = int(f.readline())
    PST = (f.readline()).strip("\n")
    textB1 = (f.readline()).strip("\n")
    textB2 = (f.readline()).strip("\n")
    mexB1 = (f.readline()).strip("\n")
    mexB2 = (f.readline()).strip("\n")
    f.close()
    serverName = serverName.replace(" ", "")
    PST = PST.replace(" ", "")

def main(*args):
    '''Main entry point for the application.'''
    initialize()
    global root
    root = tk.Tk()
    #root.protocol( 'WM_DELETE_WINDOW' , root.destroy) - sostituita in PAGINA
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = pkt_gui_rcs.PAGINA(_top1)
 
    _w1.PostName.set(PST)
 
    global oggi
    Calendario()
    Apertura = ("Avvio applicazione il " + oggi + "\n")
    Salvataggio(Apertura)
    _w1.TESTO_RX.add_text(Apertura)

    global terminale
    # create TCP socket
    terminale = Chatterbox(serverName, serverPort)
    # connect socket to remote server at (serverName, serverPort)
    terminale.connect()

    # invio sequenza di byte per attivare la risposta da parte del SoundModem
    # conforme a quanto descritto su https://www.on7lds.net/42/sites/default/files/AGWPEAPI.HTM
    # paragrafo Send UNPROTO Information (‘M’ frame) usato in questo programma
    #  e  Enable Reception of Monitoring Frames (‘m’ frame)
    a4 = chr(0) * 4
    am = chr(109)
    a11 = chr(0) * 11
    a16 = chr(0) *16
    atot = a4 + am + a11 + a16 + a4
    asend = atot.encode()
    #print(asend)
    terminale.transmit(asend)

    root.mainloop()

#*********************************************
    
def PostInserita(*args):
    global PST
    PST = (_w1.PostName.get()) # LEGGE il Testo inserito nel BOX POSTAZIONE
    PST = PST.upper()

# *****  def attivati dalla selezione dei RadioButton
def NonPartiti(*args):
    StampaRadioValue()

def Ritirati(*args):
    StampaRadioValue()

def Messaggio(*args):
    StampaRadioValue()

# Carica il valore del RadioButton Attivo
def StampaRadioValue():
    global TipoMex
    TipoMex = (_w1.RadioValue.get())

# Viene memorizzata la data e l'ora correnti alla chiamata della funzione
def Calendario():
    adesso = datetime.now()
    orario = adesso.strftime("%H:%M:%S")
    data_oggi = adesso.strftime("%d-%m-%Y")
    global oggi
    oggi =(data_oggi+" "+orario)    

# Funzione attivata dal Pulsante TEST
def sendbeacon(*args):
    StampaRadioValue()
    Calendario()
    Beacon = (oggi + " \n" + "MESSAGGIO DI PROVA da Postazione " + PST + "\n")
    Invio_SM(Beacon)

# Funzione attivata dal Pulsante INVIA
def sendtext(*args):
    StampaRadioValue()  #Chiamata alla verifica del RadioButton selezionato
    Calendario()        #Chiamata alla memorizzazione DATA e ORA correnti
    # Carico e cancellazione del testo presente nella finestra TESTO da INVIARE
    TDT = ("\r" + (_w1.TextTX.get('1.0','end')))
    _w1.TextTX.delete('1.0','end') # Cancella il testo presente nella finestra TESTO da INVIARE

  # Sostituzione caratteri accentati
    TDT = TDT.replace("ò", "o'")
    TDT = TDT.replace("à", "a'")
    TDT = TDT.replace("ù", "u'")
    TDT = TDT.replace("ì", "i'")    
    characters = "éè"
    #for x in range(len(characters)):
    for x in range(2):
        TDT = TDT.replace(characters[x], "e'")
    characters = "£ç°§"
    for x in range(4):
        TDT = TDT.replace(characters[x], "_")

    # Definizione del testo esplicativo del messaggio in base al RadioButton
    if TipoMex == 1 :
        TestoDaTrasmettere = ( mexB1 + " : " + TDT)
    elif TipoMex == 2 :
        TestoDaTrasmettere = ( mexB2 + " : " + TDT)
    elif TipoMex == 3 :
        TestoDaTrasmettere = ("MESSAGGIO INFORMATIVO: " + TDT)
    
    #Composizione del Messaggio che verà inviato
    global MessaggioCompleto
    MessaggioCompleto = ("Da Postazione " + PST + "  " + oggi + " \r" + TestoDaTrasmettere)
    Invio_SM(MessaggioCompleto)   #Chiamata all'invio del Messaggio

# COMPOSIZIONE ed INVIO della sequenza di Bites
def Invio_SM(X):       # X contiene il testo da inviare / MessaggioCompleto
    inte1 = chr(0)+chr(0)+chr(0)+chr(0)+chr(77)+chr(0) # parte iniziale intestazione
    intes3 = chr(0)     # parte finale intestazione
    mittente = PST + "_"*6 # PST è il nome della Postazione Aggiungo se è meno di 6 caratteri
    mittent1 = mittente[0:6:1]   # Devono essere inviati MAX 6 + 4 NULL caratteri
    separatore = chr(0) * 4   # 4 caratteri NULL
    destinatario = "TUTTI"+chr(0)    # sempre 6 caratteri
    num = len(X)
    numx = num - 1
    #print("Lunghezza: ",str(num))
    XT = X[0:numx:1]      # tolgo il LF finale che non so da dove arriva
    separ7 = chr(0) * 7   # 7 caratteri NULL

    b_inte1 = inte1.encode(encoding="utf-8")
    values = 240
    b_inte2 = values.to_bytes(1,'little') # parte intermedia intestazione carattere bastardo
    b_inte3 = intes3.encode(encoding="utf-8")    # fine intestazione
    b_mitte = mittent1.encode(encoding="utf-8")
    b_separ = separatore.encode(encoding="utf-8")
    b_desti = destinatario.encode(encoding="utf-8")
    b_lungh = num.to_bytes(1,'little')  # conversione lunghezza testo in carattere HEX corrispondente
    b_sepa7 = separ7.encode(encoding="utf-8")
    b_messa = XT.encode(encoding="utf-8", errors="ignore" )   # messaggio vero e proprio
    values = 13
    b_fine = values.to_bytes(1,'little')  # carattere di chiusura
    request = b_inte1 + b_inte2 +b_inte3 + b_mitte + b_separ + b_desti + b_separ + b_lungh + b_sepa7 + b_messa + b_fine
    #print(request)
    global terminale
    terminale.transmit(request)

# Creazione Directory LOGS, Apertura File LOG , Scrittura e chiusura
def Salvataggio(X):
    if not os.path.exists("LOGS"):
        os.mkdir("LOGS")
    global PST
    LOG = open("LOGS/DATI_"+PST+".log", "a")
    try:
        LOG.write(X)
    except :
        LOG.write("Stringa Eliminata per presenza caratteri NON stampabili\n")
    LOG.close()
    
if __name__ == '__main__':
    pkt_gui_rcs.start_up()
