#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
#
# GUI module generated by PAGE version 7.6
#  in conjunction with Tcl version 8.6
#    Jan 28, 2024 06:17:27 PM CET  platform: Windows NT

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
import os.path

from utility import Delivery
from utility import BufferedText

_script = sys.argv[0]
_location = os.path.dirname(_script)

global textB1
global textB2

#from pkt_gui_rcs_support import textB1, textB2
textB1 = "Bottone 1"
textB2 = "Bottone 2"

import pkt_gui_rcs_support

_bgcolor = '#d9d9d9'  # X11 color: 'gray85'
_fgcolor = '#000000'  # X11 color: 'black'
_compcolor = 'gray40' # X11 color: #666666
_ana1color = '#c3c3c3' # Closest X11 color: 'gray76'
_ana2color = 'beige' # X11 color: #f5f5dc
_tabfg1 = 'black'
_tabfg2 = 'black'
_tabbg1 = 'grey75'
_tabbg2 = 'grey89'
_bgmode = 'light'

_style_code_ran = 0
def _style_code():
    global _style_code_ran
    if _style_code_ran:
       return
    style = ttk.Style()
    if sys.platform == "win32":
       style.theme_use('winnative')
    style.configure('.',background=_bgcolor)
    style.configure('.',foreground=_fgcolor)
    style.configure('.',font='TkDefaultFont')
    style.map('.',background =
       [('selected', _compcolor), ('active',_ana2color)])
    if _bgmode == 'dark':
       style.map('.',foreground =
         [('selected', 'white'), ('active','white')])
    else:
       style.map('.',foreground =
         [('selected', 'black'), ('active','black')])
    _style_code_ran = 1

class PAGINA:
    def __init__(self, top=None):
        '''This class configures and populates the toplevel window.
           top is the toplevel containing window.'''

        #top.protocol( 'WM_DELETE_WINDOW' , self._on_close)
        top.geometry("940x650+291+37")
        #top.minsize(940, 600)
        #top.maxsize(1924, 1061)
        top.resizable(0,  0)
        top.title("RADIO CLUB SCHIO      PACKET SENDER  by P.B. Lancerotto    Vers. 1.2")
        top.configure(background="#d9d9d9")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top
        self.top.protocol( 'WM_DELETE_WINDOW' , self._on_close)
        self.PostName = tk.StringVar()
        self.TestoRicevuto = tk.StringVar()
        self.RadioValue = tk.IntVar(value=3)

        self.FrameTX = tk.Frame(self.top)
        self.FrameTX.place(relx=0.004, rely=0.571, relheight=0.285, relwidth=0.995)
        self.FrameTX.configure(relief='groove')
        self.FrameTX.configure(borderwidth="5")
        self.FrameTX.configure(relief="groove")
        self.FrameTX.configure(background="#d9ffd9")
        self.FrameTX.configure(highlightbackground="#d9d9d9")
        self.FrameTX.configure(highlightcolor="black")

        self.LabelFrTX = tk.Label(self.FrameTX)
        self.LabelFrTX.place(relx=0.011, rely=0.027, height=31, width=217)
        self.LabelFrTX.configure(activebackground="#f9f9f9")
        self.LabelFrTX.configure(anchor='nw')
        self.LabelFrTX.configure(background="#d9ffd9")
        self.LabelFrTX.configure(compound='center')
        self.LabelFrTX.configure(disabledforeground="#a3a3a3")
        self.LabelFrTX.configure(font="-family {Arial} -size 14 -weight bold")
        self.LabelFrTX.configure(foreground="#000000")
        self.LabelFrTX.configure(highlightbackground="#d9d9d9")
        self.LabelFrTX.configure(highlightcolor="black")
        self.LabelFrTX.configure(text='''TESTO da INVIARE''')

        self.TextTX = tk.Text(self.FrameTX)
        self.TextTX.place(relx=0.005, rely=0.189, relheight=0.768, relwidth=0.984)
        self.TextTX.configure(background="#ffffec")
        self.TextTX.configure(font="-family {Arial} -size 20 -weight bold")
        self.TextTX.configure(foreground="black")
        self.TextTX.configure(highlightbackground="#d9d9d9")
        self.TextTX.configure(highlightcolor="black")
        self.TextTX.configure(insertbackground="black")
        self.TextTX.configure(maxundo="5")
        self.TextTX.configure(selectbackground="#c4c4c4")
        self.TextTX.configure(selectforeground="black")
        self.TextTX.configure(undo="1")
        self.TextTX.configure(wrap="word")

        self.TITOLO = tk.Label(self.top)
        self.TITOLO.place(relx=0.011, rely=0.01, height=33, width=484)
        self.TITOLO.configure(activebackground="#f9f9f9")
        self.TITOLO.configure(anchor='w')
        self.TITOLO.configure(background="#d9d9d9")
        self.TITOLO.configure(disabledforeground="#a3a3a3")
        self.TITOLO.configure(font="-family {Arial} -size 18 -weight bold")
        self.TITOLO.configure(foreground="#000000")
        self.TITOLO.configure(highlightbackground="#d9d9d9")
        self.TITOLO.configure(highlightcolor="black")
        self.TITOLO.configure(text='''RICEZIONE ED INVIO TESTI VIA PACKET''')

        self.menubar = tk.Menu(top,font="TkMenuFont",bg=_bgcolor,fg=_fgcolor)
        top.configure(menu = self.menubar)

        self.POSTAZIONE = tk.Label(self.top)
        self.POSTAZIONE.place(relx=0.66, rely=0.0, height=14, width=94)
        self.POSTAZIONE.configure(activebackground="#f9f9f9")
        self.POSTAZIONE.configure(anchor='w')
        self.POSTAZIONE.configure(background="#d9d9d9")
        self.POSTAZIONE.configure(compound='left')
        self.POSTAZIONE.configure(disabledforeground="#a3a3a3")
        self.POSTAZIONE.configure(font="-family {Arial} -size 10 -weight bold")
        self.POSTAZIONE.configure(foreground="#000000")
        self.POSTAZIONE.configure(highlightbackground="#d9d9d9")
        self.POSTAZIONE.configure(highlightcolor="black")
        self.POSTAZIONE.configure(text='''POSTAZIONE''')

        _style_code()
        self.TEntryPostazione = ttk.Entry(self.top)
        self.TEntryPostazione.place(relx=0.596, rely=0.023, relheight=0.034, relwidth=0.219)
        self.TEntryPostazione.configure(font="-family {Arial Black} -size 12 -weight bold")
        self.TEntryPostazione.configure(justify='center')
        self.TEntryPostazione.configure(textvariable=self.PostName)
        self.TEntryPostazione.configure(validate="focusout")
        PostInserita = self.TEntryPostazione.register(pkt_gui_rcs_support.PostInserita)
        self.TEntryPostazione.configure(validatecommand=(PostInserita))
        self.TEntryPostazione.configure(takefocus="")
        #self.TEntryPostazione.configure(cursor="ibeam")

        self.BInvia = tk.Button(self.top)
        self.BInvia.place(relx=0.043, rely=0.882, height=50, width=127)
        self.BInvia.configure(activebackground="beige")
        self.BInvia.configure(activeforeground="black")
        self.BInvia.configure(background="#d9d9d9")
        self.BInvia.configure(borderwidth="5")
        self.BInvia.configure(command=pkt_gui_rcs_support.sendtext)
        self.BInvia.configure(compound='left')
        self.BInvia.configure(disabledforeground="#a3a3a3")
        self.BInvia.configure(font="-family {Arial} -size 14 -weight bold")
        self.BInvia.configure(foreground="#000000")
        self.BInvia.configure(highlightbackground="#d9d9d9")
        self.BInvia.configure(highlightcolor="black")
        self.BInvia.configure(pady="0")
        self.BInvia.configure(text='''INVIA''')
        self.BBeacon = tk.Button(self.top)
        self.BBeacon.place(relx=0.223, rely=0.882, height=50, width=127)
        self.BBeacon.configure(activebackground="beige")
        self.BBeacon.configure(activeforeground="black")
        self.BBeacon.configure(background="#d9d9d9")
        self.BBeacon.configure(borderwidth="5")
        self.BBeacon.configure(command=pkt_gui_rcs_support.sendbeacon)
        self.BBeacon.configure(compound='left')
        self.BBeacon.configure(disabledforeground="#a3a3a3")
        self.BBeacon.configure(font="-family {Arial} -size 14 -weight bold")
        self.BBeacon.configure(foreground="#000000")
        self.BBeacon.configure(highlightbackground="#d9d9d9")
        self.BBeacon.configure(highlightcolor="black")
        self.BBeacon.configure(pady="0")
        self.BBeacon.configure(text='''TEST''')
        self.RadiobuttonNP = tk.Radiobutton(self.top)
        self.RadiobuttonNP.place(relx=0.415, rely=0.894, relheight=0.034, relwidth=0.117)
        self.RadiobuttonNP.configure(activebackground="beige")
        self.RadiobuttonNP.configure(activeforeground="black")
        self.RadiobuttonNP.configure(anchor='w')
        self.RadiobuttonNP.configure(background="#d9d9d9")
        self.RadiobuttonNP.configure(command=pkt_gui_rcs_support.NonPartiti)
        self.RadiobuttonNP.configure(compound='left')
        self.RadiobuttonNP.configure(disabledforeground="#a3a3a3")
        self.RadiobuttonNP.configure(font="-family {Arial} -size 12 -weight bold")
        self.RadiobuttonNP.configure(foreground="#000000")
        self.RadiobuttonNP.configure(highlightbackground="#d9d9d9")
        self.RadiobuttonNP.configure(highlightcolor="black")
        self.RadiobuttonNP.configure(justify='left')
        self.RadiobuttonNP.configure(selectcolor="#d9d9d9")
        self.RadiobuttonNP.configure(text=textB1) #Radio Button n.1
        #self.RadiobuttonNP.configure(text='''NON Partiti''')
        self.RadiobuttonNP.configure(value='1')
        self.RadiobuttonNP.configure(variable=self.RadioValue)
        self.RadiobuttonRIT = tk.Radiobutton(self.top)
        self.RadiobuttonRIT.place(relx=0.553, rely=0.894, relheight=0.034, relwidth=0.117)
        self.RadiobuttonRIT.configure(activebackground="beige")
        self.RadiobuttonRIT.configure(activeforeground="black")
        self.RadiobuttonRIT.configure(anchor='w')
        self.RadiobuttonRIT.configure(background="#d9d9d9")
        self.RadiobuttonRIT.configure(command=pkt_gui_rcs_support.Ritirati)
        self.RadiobuttonRIT.configure(compound='left')
        self.RadiobuttonRIT.configure(disabledforeground="#a3a3a3")
        self.RadiobuttonRIT.configure(font="-family {Arial} -size 12 -weight bold")
        self.RadiobuttonRIT.configure(foreground="#000000")
        self.RadiobuttonRIT.configure(highlightbackground="#d9d9d9")
        self.RadiobuttonRIT.configure(highlightcolor="black")
        self.RadiobuttonRIT.configure(justify='left')
        self.RadiobuttonRIT.configure(selectcolor="#d9d9d9")
        self.RadiobuttonRIT.configure(text=textB2) # Radio Button n.2
        self.RadiobuttonRIT.configure(value='2')
        self.RadiobuttonRIT.configure(variable=self.RadioValue)
        self.RadiobuttonMESS = tk.Radiobutton(self.top)
        self.RadiobuttonMESS.place(relx=0.691, rely=0.894, relheight=0.034, relwidth=0.134)
        self.RadiobuttonMESS.configure(activebackground="beige")
        self.RadiobuttonMESS.configure(activeforeground="black")
        self.RadiobuttonMESS.configure(anchor='w')
        self.RadiobuttonMESS.configure(background="#d9d9d9")
        self.RadiobuttonMESS.configure(command=pkt_gui_rcs_support.Messaggio)
        self.RadiobuttonMESS.configure(compound='left')
        self.RadiobuttonMESS.configure(disabledforeground="#a3a3a3")
        self.RadiobuttonMESS.configure(font="-family {Arial} -size 12 -weight bold")
        self.RadiobuttonMESS.configure(foreground="#000000")
        self.RadiobuttonMESS.configure(highlightbackground="#d9d9d9")
        self.RadiobuttonMESS.configure(highlightcolor="black")
        self.RadiobuttonMESS.configure(justify='left')
        self.RadiobuttonMESS.configure(selectcolor="#d9d9d9")
        self.RadiobuttonMESS.configure(text='''MESSAGGIO''')
        self.RadiobuttonMESS.configure(value='3')
        self.RadiobuttonMESS.configure(variable=self.RadioValue)

        self.FrameRX = tk.Frame(self.top)
        self.FrameRX.place(relx=0.004, rely=0.069, relheight=0.498, relwidth=0.997)
        self.FrameRX.configure(relief='groove')
        self.FrameRX.configure(borderwidth="5")
        self.FrameRX.configure(relief="groove")
        self.FrameRX.configure(background="#ffffa4")
        self.FrameRX.configure(highlightbackground="#d9d9d9")
        self.FrameRX.configure(highlightcolor="black")
#************************************************************************

        self.TESTO_RX = BufferedText(self.FrameRX, rowsize=200, height=5, wrap='word')
        #self.TESTO_RX.place(relx=0.005, rely=0.10, height=285, width=915)
        self.TESTO_RX.grid(row=1, column=0, padx=(5,1), pady=(32,1), sticky='nsew')
        self.TESTO_RX.configure(font="-family {Courier} -size 14 -weight bold")
        vscroll = tk.Scrollbar(self.FrameRX, orient=tk.VERTICAL, command=self.TESTO_RX.yview)
        vscroll.grid(row=1, column=1, padx=(1,5), pady=(32,1), sticky='ns')
        self.TESTO_RX.configure(yscrollcommand=vscroll.set)
        #hscroll = tk.Scrollbar(self.FrameRX, orient=tk.HORIZONTAL, command=self.TESTO_RX.xview)
        #hscroll.grid(row=2, column=0, padx=(5,1), pady=(1,5), sticky='ew')
        #self.TESTO_RX.configure(xscrollcommand=hscroll.set)
        self.FrameRX.grid_columnconfigure(0, weight=1)
        self.FrameRX.grid_rowconfigure(1, weight=1)

#************************************************************************
        self.LabelFrRX = tk.Label(self.FrameRX)
        self.LabelFrRX.place(relx=0.011, rely=0.012, height=26, width=221)
        self.LabelFrRX.configure(activebackground="#f9f9f9")
        self.LabelFrRX.configure(anchor='nw')
        self.LabelFrRX.configure(background="#ffffa4")
        self.LabelFrRX.configure(compound='center')
        self.LabelFrRX.configure(disabledforeground="#a3a3a3")
        self.LabelFrRX.configure(font="-family {Arial} -size 14 -weight bold")
        self.LabelFrRX.configure(foreground="#000000")
        self.LabelFrRX.configure(highlightbackground="#d9d9d9")
        self.LabelFrRX.configure(highlightcolor="black")
        self.LabelFrRX.configure(text='''RICEZIONE''')

        # PER SCAMBIO MESSAGGI
        self.pub = Delivery()
        self.pub.subscribe('OBSERVER', self.obs)
        self.pub.subscribe('LISTENERS', self.obs)

    def obs(self, message: list) -> None:
        op = message[0]
        txt = ''
        if op != 'ERROR':
            txt = message[1]
            if (len(txt)) > 99:
                txt = txt[1:]
        else:
            txt = 'AVVENUTO ERRORE : ' + message[1]
            
        self.TESTO_RX.add_text(txt + '\n')
        pkt_gui_rcs_support.Salvataggio(txt + "\n")

    def _on_close(self) -> None:
        msg = ['CLOSING', 'CLOSING']
        self.pub.send_message('WORKER', msg)
        self.top.after(500, self.__close)

    def __close(self) -> None:
        self.pub.unsubscribe('OBSERVER', self.obs)
        self.pub.unsubscribe('LISTENERS', self.obs)
        self.top.destroy()

def start_up():
    pkt_gui_rcs_support.main()

if __name__ == '__main__':
    pkt_gui_rcs_support.main()

